#include <stdlib.h>
#include <string.h>

#define NB_COMMANDS 5
#define MAX_ARGS 8
#define MAX_ARGS_LEN 40
#define MAX_CMD_LEN 40

//Command Identifiers. Amend this list with your own command ids
enum Command_IDs { 
  ConnectIOAnalogInputID = 0,
  ConnectIOAnalogOutputID = 1,
  ConnectIODigitalOutputID = 2,
  ConnectIODigitalInputID = 3,
  EchoID = 4
};

//Presentation names of the Commands. Amend this list with your own command names
char* Command_List[NB_COMMANDS] = { 
  "ConnectIOAnalogInput",
  "ConnectIOAnalogOutput",
  "ConnectIODigitalOutput",
  "ConnectIODigitalInput",
  "Echo"
};

//Received Command
int Command_ID;
char arg_list[MAX_ARGS][MAX_ARGS_LEN];
char incomingByte;
int index;
char command_line[MAX_CMD_LEN];
int val_X_A0=0;
int val_X_A1=0;
int val_X_A2=0;
int val_X_A3=0;
int val_X_A4=0;
int val_X_A5=0;

int val_X_PWM5=0;
int val_X_PWM6=0; 


//This function execute a command. Amend this function with your own commands
void exec_command()
{
  char user_feedback[512];
  char voie;
    switch (Command_ID)
    {
      case ConnectIOAnalogInputID:
        if (String(arg_list[1]) == "A0")
        {
          val_X_A0 = atoi(arg_list[2]);
        }
        else if (String(arg_list[1]) == "A1")
        {
          val_X_A1 = atoi(arg_list[2]);
        }
        else if (String(arg_list[1]) == "A2")
        {
          val_X_A2 = atoi(arg_list[2]);
        }
        else if (String(arg_list[1]) == "A3")
        {
          val_X_A3 = atoi(arg_list[2]);
        }
        else if (String(arg_list[1]) == "A4")
        {
          val_X_A4 = atoi(arg_list[2]);
        }
        else if (String(arg_list[1]) == "A5")
        {
          val_X_A5 = atoi(arg_list[2]);
        }
        break;
        
      case ConnectIOAnalogOutputID:
        Serial.println(analogReadCustom(atoi(arg_list[1])));
        break;
      case ConnectIODigitalOutputID: 
        Serial.println(digitalRead(atoi(arg_list[1])));
        break;
      case ConnectIODigitalInputID:
        digitalWrite(atoi(arg_list[1]), atoi(arg_list[2]));
        //sprintf(user_feedback, "done : Inputs %i,%i", atoi(arg_list[1]), atoi(arg_list[2]));
        break;
      case EchoID:
        Serial.println(arg_list[1]);
        break;
     
      default : 
        Serial.print("Unknown Command");
        Serial.println(command_line);
    }
}

//this function parses the command so as to identify the command and its arguments
void parse_command()
{
  char *pch;
  int ii = 0;
 
  //Identify the command attributes

  pch = strtok (command_line,"|");
  while (pch != NULL)
  {
    sprintf(arg_list[ii],"%s", pch);//Write in argument table    
    pch = strtok (NULL, "|");
    ii++;
  }

  //Identify the command ID
  for (ii=0; ii<NB_COMMANDS; ii++)
  {
    if (strcmp(Command_List[ii], arg_list[0]) == 0)
    {
      Command_ID = ii;
      break;
    }
  }
}


int analogReadCustom(int pin)
{
  switch (pin)
  {
    case A0:
      return(val_X_A0);
      break;
    case A1:
      return(val_X_A1);
      break;
    case A2:
      return(val_X_A2);
      break;
    case A3:
      return(val_X_A3);
      break;
    case A4:
      return(val_X_A4);
      break;
    case A5:
      return(val_X_A5);
      break;
    case 5:
      return(val_X_PWM5);
      break;
    case 6:
      return(val_X_PWM6);
      break;
  }
}

//Ici, pin ne peut valoir que 5 ou 6 car ce sont les 2 sorties arduino PWM retenues
void analogWriteCustom(int pin,int value)
{
  analogWrite(pin,value);
  switch (pin)
  {
    case 5:
      val_X_PWM5 = value;
      break;
    case 6:
      val_X_PWM6 = value;
      break;
  }
}

void setup() {
///////////// NE PAS MODIFIER CETTE PARTIE /////////////
    for(int i = 0; i < 6; i++)
    {
     // pin #0 et #1 indisponibles, communication série rx tx
     pinMode((i+2), OUTPUT); // pin #2 à #7 en SORTIE
     pinMode((13 - i), OUTPUT); // pin #8 à #13 en ENTREE VIRTUELLE
    }
    Serial.begin(9600);
////////////////////////////////////////////////////////
}

void loop() {

///////////// NE PAS MODIFIER CETTE PARTIE /////////////
  
  #define analogWrite(pin,value) analogWriteCustom(pin,value)
  #define analogRead(pin) analogReadCustom(pin)

  if (Serial.available()) {
    incomingByte = Serial.read();
    switch (incomingByte)
    {
      case '<': //start acquisition of a new command
        index = 0;
        memset(command_line, 0, MAX_CMD_LEN - 1);//Set command to 0
        break;
      case '>': // finish acquisition of current command
        command_line[index+1] = 0;
        parse_command();
        exec_command();
        break;
      default : // command acquisition
        command_line[index++] = incomingByte;
    }
  }
////////////////////////////////////////////////////////

///////////// SAISIR VOTRE CODE CI-DESSOUS /////////////
////Exemple de code avec le plugin ARDUINO_UNO_ANALOG de CONNECT IO /////

///////////// ENTER YOUR CODE BELOW /////////////
////Example code with the ARDUINO_UNO_ANALOG plugin from CONNECT IO /////

  int valeurPin13 = digitalRead(13);  // Lire la valeur du pin 13
  int valeurPin12 = digitalRead(12); 
  int valeurPin11 = digitalRead(11); 
  int valeurPin10 = digitalRead(10); 
  int valeurPin9 = digitalRead(9); 
  int valeurPin8 = digitalRead(8); 
  
  int valeurPinA0 = analogRead(A0);
  int valeurPinA1 = analogRead(A1);
  int valeurPinA2 = analogRead(A2);
  int valeurPinA3 = analogRead(A3);
  int valeurPinA4 = analogRead(A4);
  int valeurPinA5 = analogRead(A5);

  digitalWrite(2, valeurPin13); 
  digitalWrite(3, valeurPin12); 
  digitalWrite(4, valeurPin11); 
  digitalWrite(7, valeurPin10); 
  
  analogWrite(5,valeurPinA0/4);
  analogWrite(6,valeurPinA1/4);
  
}
